/*========================================================================*/  
/* Copyright 1997 National Insttruments Corporation. All Rights Reserved. */
/*========================================================================*/

#include <formatio.h>
#include <visa.h>
#include <stdlib.h>
#include <stdio.h>
#include <utility.h>

#include "gwsfg830.h"
    
#define gwsfg830_REVISION     "Rev 1.0, 12/97, CVI 4.0.1" /*  Instrument driver revision */
#define BUFFER_SIZE         512L         /* File I/O buffer size */
        
/*= GOODWILL SFG830 Synthesized Function Generator (VISA I/O) ===============*/
/* LabWindows/CVI 4.0.1 Instrument Driver                                    */
/* Original Release: December 1997                                           */
/* Original language: C language                                             */
/* By: Fu_jen                                                                */
/*     PH. (02)9142619           Fax  (02)9148733                            */
/*                                                                           */
/* For LabWindows Technical Support in the United States call:               */
/*     National Instruments, Austin, Texas                                   */
/*     Ph (800) 433-3488    Fax (512) 794-5678                               */
/*                                                                           */
/* Modification History: None                                                */
/*                                                                           */
/*===========================================================================*/

/*****************************************************************************/
/*= INSTRUMENT-DEPENDENT COMMAND ARRAYS =====================================*/
/*****************************************************************************/
static ViString cmd_arr[]={"syst:err?","sour:freq:synt?","sour:ampl:lev?",
                           "sour:offs:lev?","sour:phas:adj?","sour:swe:rate?",
                           "sour:func:fm:dev?","sour:func:am:dept?"};

/*****************************************************************************/
/*= INSTRUMENT-DEPENDENT STATUS/RANGE STRUCTURE  ============================*/
/*****************************************************************************/
/* gwsfg830_stringValPair is used in the gwsfg830_errorMessage function      */
/* gwsfg830_statusDataRanges is used to track session dependent status & ranges*/
/*===========================================================================*/
typedef struct  gwsfg830_stringValPair
{
   ViStatus stringVal;
   ViString stringName;
}  gwsfg830_tStringValPair;
 
    /*=CHANGE:=============================================================*/
    /* Change to reflect the global status variables that your driver needs*/
    /* to keep track of.  For example trigger mode of each session         */
    /*=====================================================================*/
struct gwsfg830_statusDataRanges {
    ViInt16 triggerMode;
    ViInt16 val2;
    ViInt16 val3;
    ViChar instrDriverRevision[256];
};
typedef struct gwsfg830_statusDataRanges *gwsfg830_instrRange;

/*****************************************************************************/
/*= UTILITY ROUTINE DECLARATIONS (Non-Exportable Functions) =================*/
/*****************************************************************************/
ViBoolean gwsfg830_invalidViBooleanRange (ViBoolean val);
ViBoolean gwsfg830_invalidViInt16Range (ViInt16 val, ViInt16 min, ViInt16 max);
ViBoolean gwsfg830_invalidViInt32Range (ViInt32 val, ViInt32 min, ViInt32 max);
ViBoolean gwsfg830_invalidViUInt8Range (ViUInt8 val, ViUInt8 min, ViUInt8 max);
ViBoolean gwsfg830_invalidViUInt16Range (ViUInt16 val, ViUInt16 min, ViUInt16 max);
ViBoolean gwsfg830_invalidViUInt32Range (ViUInt32 val, ViUInt32 min, ViUInt32 max);
ViBoolean gwsfg830_invalidViReal32Range (ViReal32 val, ViReal32 min, ViReal32 max);
ViBoolean gwsfg830_invalidViReal64Range (ViReal64 val, ViReal64 min, ViReal64 max);
ViStatus gwsfg830_initCleanUp (ViSession openRMSession, ViPSession openInstrSession, ViStatus currentStatus);
ViStatus gwsfg830_readToFile (ViSession instrSession, ViString filename, ViUInt32 readBytes, ViPUInt32 retCount);
ViStatus gwsfg830_writeFromFile (ViSession instrSession, ViString filename, ViUInt32 writeBytes, ViPUInt32 retCount);
ViStatus gwsfg830_defaultInstrSetup (ViSession openInstrSession);

/*****************************************************************************/
/*------ INSERT INSTRUMENT-DEPENDENT UTILITY ROUTINE DECLARATIONS HERE ------*/
/*****************************************************************************/
  
/*****************************************************************************/
/*====== USER-CALLABLE FUNCTIONS (Exportable Functions) =====================*/
/*****************************************************************************/
      
/*===========================================================================*/
/* Function: Initialize                                                      */
/* Purpose:  This function opens the instrument, queries the instrument      */
/*           for its ID, and initializes the instrument to a known state.    */
/*===========================================================================*/
ViStatus _VI_FUNC gwsfg830_init (ViRsrc resourceName, ViBoolean IDQuery,
                    ViBoolean resetDevice, ViPSession instrSession)
{
    ViStatus gwsfg830_status = VI_SUCCESS;
    ViSession rmSession = 0;
    ViUInt32 retCnt = 0;
    ViByte rdBuffer[BUFFER_SIZE];

    /*- Check input parameter ranges ----------------------------------------*/
    if (gwsfg830_invalidViBooleanRange (IDQuery))
        return VI_ERROR_PARAMETER2;
    if (gwsfg830_invalidViBooleanRange (resetDevice))
        return VI_ERROR_PARAMETER3;

    /*- Open instrument session ---------------------------------------------*/
    if ((gwsfg830_status = viOpenDefaultRM (&rmSession)) < 0)
        return gwsfg830_status;

    if ((gwsfg830_status = viOpen (rmSession, resourceName, VI_NULL, VI_NULL, instrSession)) < 0) {
        viClose (rmSession);
        return gwsfg830_status;
    }

    /*- Configure VISA Formatted I/O ----------------------------------------*/
    if ((gwsfg830_status = viSetAttribute (*instrSession, VI_ATTR_TMO_VALUE, 10000)) < 0)
            return gwsfg830_initCleanUp (rmSession, instrSession, gwsfg830_status);
  
    if ((gwsfg830_status = viSetBuf (*instrSession, VI_READ_BUF|VI_WRITE_BUF, 4000)) < 0)
            return gwsfg830_initCleanUp (rmSession, instrSession, gwsfg830_status);
  
    if ((gwsfg830_status = viSetAttribute (*instrSession, VI_ATTR_WR_BUF_OPER_MODE,
                            VI_FLUSH_ON_ACCESS)) < 0)
            return gwsfg830_initCleanUp (rmSession, instrSession, gwsfg830_status);
    
    if ((gwsfg830_status = viSetAttribute (*instrSession, VI_ATTR_RD_BUF_OPER_MODE,
                            VI_FLUSH_ON_ACCESS)) < 0)
            return gwsfg830_initCleanUp (rmSession, instrSession, gwsfg830_status);

    /*- Identification Query ------------------------------------------------*/
    
    if (IDQuery) {
        if ((gwsfg830_status = viWrite (*instrSession, "*IDN?", 5, &retCnt)) < 0)
            return gwsfg830_initCleanUp (rmSession, instrSession, gwsfg830_status);
        if ((gwsfg830_status = viRead (*instrSession, rdBuffer, BUFFER_SIZE, &retCnt)) < 0)
            return gwsfg830_status;

        Scan (rdBuffer, "GW.Inc,SFG-830");
        if (NumFmtdBytes () != 14) 
            return gwsfg830_initCleanUp (rmSession, instrSession, VI_ERROR_FAIL_ID_QUERY);
    }
        
    
    /*- Reset instrument ----------------------------------------------------*/
    if (resetDevice) {
        if ((gwsfg830_status = gwsfg830_reset (*instrSession)) < 0)
            return gwsfg830_initCleanUp (rmSession, instrSession, gwsfg830_status);
    }       
    else  /*- Send Default Instrument Setup ---------------------------------*/
        if ((gwsfg830_status = gwsfg830_defaultInstrSetup (*instrSession)) < 0)
            return gwsfg830_initCleanUp (rmSession, instrSession, gwsfg830_status);
          
    return gwsfg830_status;
}

/*===========================================================================*/
/* Function: Generate Waveform                                               */
/* Purpose:  This application function causes the instrument to generate a   */
/*           waveform.  This function sets the Waveform type, Frequency,     */
/*           Amplitude and DC Offset.                                        */
/*===========================================================================*/
ViStatus _VI_FUNC gwsfg830_generateWaveform (ViSession instrSession, ViInt16 wvfmType,
                    ViReal64 sampFreq, ViReal64 ampl, ViReal64 DCOffset)
{
    ViStatus gwsfg830_status = VI_SUCCESS;
     
    if (gwsfg830_invalidViInt16Range (wvfmType, 1, 5))
        return VI_ERROR_PARAMETER2;
    if (gwsfg830_invalidViReal64Range (sampFreq, 0.0, 3.0E+7))
        return VI_ERROR_PARAMETER3;
    if (gwsfg830_invalidViReal64Range (ampl, 0.0, 10.0))
        return VI_ERROR_PARAMETER4;
    if (gwsfg830_invalidViReal64Range (DCOffset, -5.0, 5.0))
        return VI_ERROR_PARAMETER5;

    if (gwsfg830_status = gwsfg830_configWvfm (instrSession, wvfmType,sampFreq, ampl, DCOffset))
        return gwsfg830_status;

    return gwsfg830_status;
}

/*===========================================================================*/
/* Function: Configure Waveform                                              */
/* Purpose:  This function programs the instrument to generate the waveform  */
/*           specified by the "Waveform Type" control.                       */
/*===========================================================================*/
ViStatus _VI_FUNC gwsfg830_configWvfm (ViSession instrSession, ViInt16 wvfmType,
                    ViReal64 sampFreq, ViReal64 ampl, ViReal64 DCOffset)
{
    ViStatus gwsfg830_status = VI_SUCCESS;
    ViUInt32 retCnt = 0;
    ViByte wrtBuff[BUFFER_SIZE] = "\0";
                        
    if (gwsfg830_invalidViInt16Range (wvfmType, 1, 5))
        return VI_ERROR_PARAMETER2;
    if (gwsfg830_invalidViReal64Range (sampFreq, 0.0, 3.0E+7))
        return VI_ERROR_PARAMETER3;
    if (gwsfg830_invalidViReal64Range (ampl, 0.0, 10.0))
        return VI_ERROR_PARAMETER4;
    if (gwsfg830_invalidViReal64Range (DCOffset, -5.0, 5.0))
        return VI_ERROR_PARAMETER5;

    if (ampl + DCOffset > 10.0)  {
        gwsfg830_status =  gwsfg830_ERROR_AMP_AND_OFF;
        return gwsfg830_status;
    }
    
    switch (wvfmType)  {
        case 1:
            if (gwsfg830_invalidViReal64Range (sampFreq, 0, 3.0E+7))
                return VI_ERROR_PARAMETER3;
            Fmt (wrtBuff, "%s<sour:func:sin");
            break;
        case 2:
            if (gwsfg830_invalidViReal64Range (sampFreq, 0, 3.0E+7))
                return VI_ERROR_PARAMETER3;
            Fmt (wrtBuff, "%s<sour:func:squ");
            break;
        case 3:
            if (gwsfg830_invalidViReal64Range (sampFreq, 0, 1.0E+5))
                return VI_ERROR_PARAMETER3;
            Fmt (wrtBuff, "%s<sour:func:tri");
            break;
        case 4:
            if (gwsfg830_invalidViReal64Range (sampFreq, 0, 1.0E+5))
                return VI_ERROR_PARAMETER3;
            Fmt (wrtBuff, "%s<sour:func:ramp");
            break;
        case 5:
            if (gwsfg830_invalidViReal64Range (sampFreq, 0, 3.0E+7))
                return VI_ERROR_PARAMETER3;
            Fmt (wrtBuff, "%s<sour:func:arb");
            break;
    }
    if ((gwsfg830_status = viWrite (instrSession, wrtBuff, NumFmtdBytes(), &retCnt)) < 0)
        return gwsfg830_status;
        
    Fmt (wrtBuff, "%s<sour:freq:synt %f;:sour:ampl:lev %f;:sour:offs:lev %f",sampFreq, ampl, DCOffset);
    if ((gwsfg830_status = viWrite (instrSession, wrtBuff, NumFmtdBytes(), &retCnt)) < 0)
        return gwsfg830_status;
        
    return gwsfg830_status;
}

/*===========================================================================*/
/* Function: Configure AM/FM                                                 */
/* Purpose:  This function programs the instrument to generate the AM/FM     */
/*           modulation specified by the depth,rate and modulation waveform. */
/*===========================================================================*/
ViStatus _VI_FUNC gwsfg830_configAMFM (ViSession instrSession,
                    ViInt16 moduWvfm, ViBoolean modulationType,
                    ViReal64 depthSpan, ViReal64 sweepRate)
{
    ViStatus gwsfg830_status = VI_SUCCESS;
    ViUInt32 retCnt = 0;
    ViByte wrtBuff[BUFFER_SIZE] = "\0";

    if (gwsfg830_invalidViInt16Range (moduWvfm, 1, 4))
        return VI_ERROR_PARAMETER2;
    if (gwsfg830_invalidViBooleanRange (modulationType))
        return VI_ERROR_PARAMETER3;
    if (modulationType == VI_OFF) { //AM
        if (gwsfg830_invalidViReal64Range (depthSpan, -100.0,100.0))
            return VI_ERROR_PARAMETER4;
    }
    else { //FM
        if (gwsfg830_invalidViReal64Range (depthSpan, 0.0,3.0E+7))
            return VI_ERROR_PARAMETER3;
    }
    if (gwsfg830_invalidViReal64Range (sweepRate, 0.01,10000.0))
        return VI_ERROR_PARAMETER4;
        
    if (modulationType == VI_OFF) { //AM
        Fmt (wrtBuff, "%s<sour:func:sour %d[b2];:sour:func:am:dept %f;:sour:swe:rate %f",moduWvfm,depthSpan,sweepRate);
        if ((gwsfg830_status = viWrite (instrSession, wrtBuff, NumFmtdBytes(), &retCnt)) < 0)
            return gwsfg830_status;

        Fmt (wrtBuff, "%s<sour:func:am:stat on");
    }
    else { //FM
        Fmt (wrtBuff, "%s<sour:func:sour %d[b2];:sour:func:fm:dev %f;:sour:swe:rate %f",moduWvfm,depthSpan,sweepRate);
        if ((gwsfg830_status = viWrite (instrSession, wrtBuff, NumFmtdBytes(), &retCnt)) < 0)
            return gwsfg830_status;

        Fmt (wrtBuff, "%s<sour:func:fm:stat on");
    }
        
    if ((gwsfg830_status = viWrite (instrSession, wrtBuff, NumFmtdBytes(), &retCnt)) < 0)
        return gwsfg830_status;
    
    return gwsfg830_status;
}

/*===========================================================================*/
/* Function: Configure PM                                                    */
/* Purpose:  This function programs the instrument to generate the PM        */
/*           modulation specified by the phase and rate controls.            */
/*===========================================================================*/
ViStatus _VI_FUNC gwsfg830_configPM (ViSession instrSession,ViReal64 phase, ViReal64 rate)
{
    ViStatus gwsfg830_status = VI_SUCCESS;
    ViUInt32 retCnt = 0;
    ViByte wrtBuff[BUFFER_SIZE] = "\0";

    if (gwsfg830_invalidViReal64Range (phase, 0.0,360.0))
        return VI_ERROR_PARAMETER2;
    if (gwsfg830_invalidViReal64Range (rate, 0.0,10000.0))
        return VI_ERROR_PARAMETER3;

    Fmt (wrtBuff, "%s<sour:func:sour 4;:sour:phas:adj %f;:sour:swe:rate %f",phase,rate);
    if ((gwsfg830_status = viWrite (instrSession, wrtBuff, NumFmtdBytes(), &retCnt)) < 0)
        return gwsfg830_status;

    Fmt (wrtBuff, "%s<sour:func:pm:stat on");
    if ((gwsfg830_status = viWrite (instrSession, wrtBuff, NumFmtdBytes(), &retCnt)) < 0)
        return gwsfg830_status;
        
    return gwsfg830_status;
}

/*===========================================================================*/
/* Function: Configure Log/Linear                                            */
/* Purpose:  This function programs the instrument to generate the LOG/LINear*/
/*           sweep specified by the start,stop,rate and modulation waveform. */
/*===========================================================================*/
ViStatus _VI_FUNC gwsfg830_configLogLin (ViSession instrSession,
                    ViInt16 sweepType, ViInt16 moduWvfm,
                    ViReal64 start, ViReal64 stop,
                    ViReal64 sweepRate)
{
    ViStatus gwsfg830_status = VI_SUCCESS;
    ViUInt32 retCnt = 0;
    ViByte wrtBuff[BUFFER_SIZE] = "\0";

    if (gwsfg830_invalidViBooleanRange (sweepType))
        return VI_ERROR_PARAMETER2;
    if (gwsfg830_invalidViInt16Range (moduWvfm, 3, 4))
        return VI_ERROR_PARAMETER3;
    if (gwsfg830_invalidViReal64Range (start, 0.0,3.0E+7))
        return VI_ERROR_PARAMETER3;
    if (gwsfg830_invalidViReal64Range (stop, 0.0,3.0E+7))
        return VI_ERROR_PARAMETER4;
    if (stop <= start)
        return VI_ERROR_PARAMETER4;
    if (gwsfg830_invalidViReal64Range (sweepRate, 0.01,1000.0))
        return VI_ERROR_PARAMETER5;

    if (sweepType == VI_OFF) { //Lin
        Fmt (wrtBuff, "%s<sour:func:sour %d;:sour:swe:rate %f;:sour:swe:spac lin", moduWvfm, sweepRate);
        if ((gwsfg830_status = viWrite (instrSession, wrtBuff, NumFmtdBytes(), &retCnt)) < 0)
            return gwsfg830_status;

        Fmt (wrtBuff, "%s<sour:freq:start %f;:sour:freq:stop %f",start, stop);
    }
    else { //Log
        Fmt (wrtBuff, "%s<sour:func:sour %d;:sour:swe:rate %f;:sour:swe:spac log", moduWvfm, sweepRate);
        if ((gwsfg830_status = viWrite (instrSession, wrtBuff, NumFmtdBytes(), &retCnt)) < 0)
            return gwsfg830_status;

        Fmt (wrtBuff, "%s<sour:freq:start %f;:sour:freq:stop %f",start, stop);
    }
    
    if ((gwsfg830_status = viWrite (instrSession, wrtBuff, NumFmtdBytes(), &retCnt)) < 0)
        return gwsfg830_status;
        
    return gwsfg830_status;
}

/*===========================================================================*/
/* Function: Set Modulation State                                            */
/* Purpose:  This function programs the device to turn the modulation state  */
/*           On or Off.                                                      */
/*===========================================================================*/
ViStatus _VI_FUNC gwsfg830_setmodulation (ViSession instrSession,ViBoolean setModulationState)
{
    ViStatus gwsfg830_status = VI_SUCCESS;
    ViUInt32 retCnt = 0;
    ViByte wrtBuff[BUFFER_SIZE] = "\0";

    if (gwsfg830_invalidViBooleanRange (setModulationState))
        return VI_ERROR_PARAMETER2;
        
    Fmt (wrtBuff, "sour:mod:stat %d[b2]", (ViInt16)setModulationState);
    if ((gwsfg830_status = viWrite (instrSession, wrtBuff, NumFmtdBytes(), &retCnt)) < 0)
        return gwsfg830_status;

    return gwsfg830_status;
}

/*===========================================================================*/
/* Function: Read Instrument Settings                                        */
/* Purpose:  This function queries the instrument for the specifed data,     */
/*           status, or setup information.                                   */
/*===========================================================================*/
ViStatus _VI_FUNC gwsfg830_dataReadSetting (ViSession instrSession, ViInt16 messageType, ViChar  _VI_FAR message[])
{
    ViStatus gwsfg830_status = VI_SUCCESS;
    ViUInt32 retCnt = 0;
    ViByte wrtBuff[BUFFER_SIZE] = "\0", rdBuff[BUFFER_SIZE] = "\0";

    if (gwsfg830_invalidViInt16Range (messageType, 0, 7))
        return VI_ERROR_PARAMETER2;

    Fmt (wrtBuff, "%s", cmd_arr[messageType]);
    if ((gwsfg830_status = viWrite (instrSession, wrtBuff, NumFmtdBytes(), &retCnt)) < 0)
        return gwsfg830_status;
    if ((gwsfg830_status = viRead (instrSession, rdBuff, BUFFER_SIZE, &retCnt)) < 0)
        return gwsfg830_status;
    
    if (Scan (rdBuff, "%s>%s[t-]", message) != 1) 
        return VI_ERROR_INSTR_INTERPRETING_RESPONSE;
    
    return gwsfg830_status;
}

/*===========================================================================*/
/* Function: Write To Instrument                                             */
/* Purpose:  This function writes a command string to the instrument.        */
/*===========================================================================*/
ViStatus _VI_FUNC gwsfg830_writeInstrData (ViSession instrSession, ViString writeBuffer)
{
    ViStatus gwsfg830_status = VI_SUCCESS;
    
    if ((gwsfg830_status = viPrintf (instrSession, "%s", writeBuffer)) < 0)
        return gwsfg830_status;

    return gwsfg830_status;
}

/*===========================================================================*/
/* Function: Read Instrument Buffer                                          */
/* Purpose:  This function reads the output buffer of the instrument.        */
/*===========================================================================*/
ViStatus _VI_FUNC gwsfg830_readInstrData (ViSession instrSession, ViInt32 numberBytesToRead,
                    ViChar _VI_FAR readBuffer[], ViPInt32 numBytesRead)
{
    ViStatus gwsfg830_status = VI_SUCCESS;
    *numBytesRead = 0L;
        
    if ((gwsfg830_status = viRead (instrSession, readBuffer, numberBytesToRead, numBytesRead)) < 0)
        return gwsfg830_status;

    return gwsfg830_status;
}

/*===========================================================================*/
/* Function: Reset                                                           */
/* Purpose:  This function resets the instrument.  If the reset function     */
/*           is not supported by the instrument, this function returns       */
/*           the warning VI_WARN_NSUP_RESET.                                 */
/*===========================================================================*/
ViStatus _VI_FUNC gwsfg830_reset (ViSession instrSession)
{
    ViUInt32 retCnt = 0;
    ViStatus gwsfg830_status = VI_SUCCESS;

    Delay(1.0);
    /*  Initialize the instrument to a known state.  */
    if ((gwsfg830_status = viWrite (instrSession, "*RST", 4, &retCnt)) < 0)
        return gwsfg830_status;

    if ((gwsfg830_status = gwsfg830_defaultInstrSetup (instrSession)) < 0)  
        return gwsfg830_status;
        
       
    return gwsfg830_status;
}

/*===========================================================================*/
/* Function: Self-Test                                                       */
/* Purpose:  This function executes the instrument self-test and returns     */
/*           the result. If the self test function is not supported by the   */
/*           instrument, this function returns the warning                   */
/*           VI_WARN_NSUP_SELF_TEST.                                         */
/*===========================================================================*/
ViStatus _VI_FUNC gwsfg830_selfTest (ViSession instrSession, ViPInt16 testResult,
                    ViChar _VI_FAR testMessage[])
{
    ViUInt32 retCnt = 0;
    ViStatus gwsfg830_status = VI_SUCCESS;
                              
    if ((gwsfg830_status = viWrite (instrSession, "*TST?", 5, &retCnt)) < 0)
        return gwsfg830_status;
                            
    if ((gwsfg830_status = viScanf (instrSession, "%hd,\"%[^\"]", testResult, testMessage)) < 0)
        return gwsfg830_status;
                           
    return gwsfg830_status;
}

/*===========================================================================*/
/* Function: Error Query                                                     */
/* Purpose:  This function queries the instrument error queue, and returns   */
/*           the result. If the error query function is not supported by the  */
/*           instrument, this function returns the warning                   */
/*           VI_WARN_NSUP_ERROR_QUERY.                                       */
/*===========================================================================*/
ViStatus _VI_FUNC gwsfg830_errorQuery (ViSession instrSession, ViPInt32 errorCode,
                    ViChar _VI_FAR errorMessage[])
{
    ViUInt32 retCnt = 0;
    ViStatus gwsfg830_status = VI_SUCCESS;
         
    if ((gwsfg830_status = viWrite (instrSession, "SYST:ERR?", 9, &retCnt)) < 0)
        return gwsfg830_status;
                    
    if ((gwsfg830_status = viScanf (instrSession, "%ld,\"%[^\"]", errorCode, errorMessage)) < 0)
        return gwsfg830_status;
                    
    return gwsfg830_status;
}

/*===========================================================================*/
/* Function: Error Message                                                   */
/* Purpose:  This function translates the error return value from the        */
/*           instrument driver into a user-readable string.                  */
/*===========================================================================*/
ViStatus _VI_FUNC gwsfg830_errorMessage (ViSession instrSession, ViStatus statusCode,
                    ViChar _VI_FAR message[])
{
    ViStatus gwsfg830_status = VI_SUCCESS;
    ViInt16 i;
    static gwsfg830_tStringValPair statusDescArray[] = {
        {VI_WARN_NSUP_ID_QUERY,     "WARNING: ID Query not supported"},
        {VI_WARN_NSUP_RESET,        "WARNING: Reset not supported"},
        {VI_WARN_NSUP_SELF_TEST,    "WARNING: Self-test not supported"},
        {VI_WARN_NSUP_ERROR_QUERY,  "WARNING: Error Query not supported"},     
        {VI_WARN_NSUP_REV_QUERY,    "WARNING: Revision Query not supported"},
        {VI_ERROR_PARAMETER1,   "ERROR: Parameter 1 out of range"},
        {VI_ERROR_PARAMETER2,   "ERROR: Parameter 2 out of range"},
        {VI_ERROR_PARAMETER3,   "ERROR: Parameter 3 out of range"},
        {VI_ERROR_PARAMETER4,   "ERROR: Parameter 4 out of range"},
        {VI_ERROR_PARAMETER5,   "ERROR: Parameter 5 out of range"},
        {VI_ERROR_PARAMETER6,   "ERROR: Parameter 6 out of range"},
        {VI_ERROR_PARAMETER7,   "ERROR: Parameter 7 out of range"},
        {VI_ERROR_PARAMETER8,   "ERROR: Parameter 8 out of range"},
        {VI_ERROR_FAIL_ID_QUERY,"ERROR: Identification query failed"},
        {VI_ERROR_INV_RESPONSE, "ERROR: Interpreting instrument response"},
        {VI_ERROR_INSTR_FILE_OPEN,    "ERROR: Opening the specified file"},
        {VI_ERROR_INSTR_FILE_WRITE,   "ERROR: Writing to the specified file"},
        {VI_ERROR_INSTR_INTERPRETING_RESPONSE, "ERROR: Interpreting the instrument's response"},
        {gwsfg830_ERROR_PROGRAMMING_INSTR,   "ERROR: Programming the Instrument"},
        {gwsfg830_ERROR_AMP_AND_OFF, "ERROR: Sum of Offset and Amplitude greater than allowed value"},
        {VI_NULL, VI_NULL}
    };

    gwsfg830_status = viStatusDesc (instrSession, statusCode, message);
    if (gwsfg830_status == VI_WARN_UNKNOWN_STATUS) {
        for (i=0; statusDescArray[i].stringName; i++) {
            if (statusDescArray[i].stringVal == statusCode) {
                Fmt (message, "%s<%s", statusDescArray[i].stringName);
                return (VI_SUCCESS);
            }
        }
        Fmt (message, "%s<Unknown Error 0x%x[uw8p0]", statusCode);
        return (VI_WARN_UNKNOWN_STATUS);
    }
    
    gwsfg830_status = VI_SUCCESS;
    return gwsfg830_status;
}

/*===========================================================================*/
/* Function: Revision Query                                                  */
/* Purpose:  This function returns the driver and instrument revisions.      */
/*===========================================================================*/
ViStatus _VI_FUNC gwsfg830_revisionQuery (ViSession instrSession,
                    ViChar _VI_FAR driverRev[], ViChar _VI_FAR instrRev[])
{
    ViUInt32 retCnt = 0;
    ViStatus gwsfg830_status = VI_SUCCESS;

    /* Query instrument firmware revision.*/                                 
    if ((gwsfg830_status = viWrite (instrSession, "*IDN?", 5, &retCnt)) < 0)
        return gwsfg830_status;
        
    if ((gwsfg830_status = viScanf (instrSession, "%*[^,],%*[^,],%*[^,],%[^\n]", instrRev)) < 0)
        return gwsfg830_status;
        
    Fmt(driverRev,"%s<%s",gwsfg830_REVISION);
    
    return gwsfg830_status;
}

/*===========================================================================*/
/* Function: Close                                                           */
/* Purpose:  This function closes the instrument.                            */
/*===========================================================================*/
ViStatus _VI_FUNC gwsfg830_close (ViSession instrSession)
{
    gwsfg830_instrRange instrPtr;
    ViSession rmSession;
    ViStatus gwsfg830_status = VI_SUCCESS;

    if ((gwsfg830_status = viGetAttribute (instrSession, VI_ATTR_RM_SESSION, &rmSession)) < 0)
        return gwsfg830_status;
    if ((gwsfg830_status = viGetAttribute (instrSession, VI_ATTR_USER_DATA, &instrPtr)) < 0)
        return gwsfg830_status;
            
    if (instrPtr != NULL) 
        free (instrPtr);
    
    gwsfg830_status = viClose (instrSession);
    viClose (rmSession);

    return gwsfg830_status;
}

/*****************************************************************************/
/*= UTILITY ROUTINES (Non-Exportable Functions) =============================*/
/*****************************************************************************/

/*===========================================================================*/
/* Function: Boolean Value Out Of Range - ViBoolean                          */
/* Purpose:  This function checks a Boolean to see if it is equal to VI_TRUE */
/*           or VI_FALSE. If the value is out of range, the return value is  */
/*           VI_TRUE, otherwise the return value is VI_FALSE.                */
/*===========================================================================*/
ViBoolean gwsfg830_invalidViBooleanRange (ViBoolean val)
{
    return ((val != VI_FALSE && val != VI_TRUE) ? VI_TRUE : VI_FALSE);
}

/*===========================================================================*/
/* Function: Short Signed Integer Value Out Of Range - ViInt16               */
/* Purpose:  This function checks a short signed integer value to see if it  */  
/*           lies between a minimum and maximum value.  If the value is out  */
/*           of range, the return value is VI_TRUE, otherwise the return     */
/*           value is VI_FALSE.                                              */
/*===========================================================================*/
ViBoolean gwsfg830_invalidViInt16Range (ViInt16 val, ViInt16 min, ViInt16 max)
{
    return ((val < min || val > max) ? VI_TRUE : VI_FALSE);
}

/*===========================================================================*/
/* Function: Long Signed Integer Value Out Of Range - ViInt32                */
/* Purpose:  This function checks a long signed integer value to see if it   */  
/*           lies between a minimum and maximum value.  If the value is out  */
/*           of range, the return value is VI_TRUE, otherwise the return     */
/*           value is VI_FALSE.                                              */
/*===========================================================================*/
ViBoolean gwsfg830_invalidViInt32Range (ViInt32 val, ViInt32 min, ViInt32 max)
{
    return ((val < min || val > max) ? VI_TRUE : VI_FALSE);
}

/*===========================================================================*/
/* Function: Unsigned Char Value Out Of Range - ViUInt8                      */
/* Purpose:  This function checks an unsigned char value to see if it        */  
/*           lies between a minimum and maximum value.  If the value is out  */
/*           of range, the return value is VI_TRUE, otherwise the return     */
/*           value is VI_FALSE.                                              */
/*===========================================================================*/
ViBoolean gwsfg830_invalidViUInt8Range (ViUInt8 val, ViUInt8 min, ViUInt8 max)
{
    return ((val < min || val > max) ? VI_TRUE : VI_FALSE);
}

/*===========================================================================*/
/* Function: Short Unsigned Integer Value Out Of Range - ViUInt16            */
/* Purpose:  This function checks a short unsigned integer value to see if it*/  
/*           lies between a minimum and maximum value.  If the value is out  */
/*           of range, the return value is VI_TRUE, otherwise the return     */
/*           value is VI_FALSE.                                              */
/*===========================================================================*/
ViBoolean gwsfg830_invalidViUInt16Range (ViUInt16 val, ViUInt16 min, ViUInt16 max)
{
    return ((val < min || val > max) ? VI_TRUE : VI_FALSE);
}

/*===========================================================================*/
/* Function: Long Unsigned Integer Value Out Of Range - ViUInt32             */
/* Purpose:  This function checks a long unsigned integer value to see if it */  
/*           lies between a minimum and maximum value.  If the value is out  */
/*           of range, the return value is VI_TRUE, otherwise the return     */
/*           value is VI_FALSE.                                              */
/*===========================================================================*/
ViBoolean gwsfg830_invalidViUInt32Range (ViUInt32 val, ViUInt32 min, ViUInt32 max)
{
    return ((val < min || val > max) ? VI_TRUE : VI_FALSE);
}

/*===========================================================================*/
/* Function: Real (Float) Value Out Of Range - ViReal32                      */
/* Purpose:  This function checks a real (float) value to see if it lies     */  
/*           between a minimum and maximum value.  If the value is out of    */
/*           range, the return value is VI_TRUE, otherwise the return value  */
/*           is VI_FALSE.                                                    */
/*===========================================================================*/
ViBoolean gwsfg830_invalidViReal32Range (ViReal32 val, ViReal32 min, ViReal32 max)
{
    return ((val < min || val > max) ? VI_TRUE : VI_FALSE);
}

/*===========================================================================*/
/* Function: Real (Double) Value Out Of Range - ViReal64                     */
/* Purpose:  This function checks a real (double) value to see if it lies    */  
/*           between a minimum and maximum value.  If the value is out of    */
/*           range, the return value is VI_TRUE, otherwise the return value  */
/*           is VI_FALSE.                                                    */
/*===========================================================================*/
ViBoolean gwsfg830_invalidViReal64Range (ViReal64 val, ViReal64 min, ViReal64 max)
{
    return ((val < min || val > max) ? VI_TRUE : VI_FALSE);
}

/*===========================================================================*/
/* Function: Initialize Clean Up                                             */
/* Purpose:  This function is used only by the gwsfg830_init function.  When   */
/*           an error is detected this function is called to close the       */
/*           open resource manager and instrument object sessions and to     */
/*           set the instrSession that is returned from gwsfg830_init to       */
/*           VI_NULL.                                                        */
/*===========================================================================*/
ViStatus gwsfg830_initCleanUp (ViSession openRMSession,
                    ViPSession openInstrSession, ViStatus currentStatus)
{
    viClose (*openInstrSession);
    viClose (openRMSession);
    *openInstrSession = VI_NULL;
    
    return currentStatus;
}

/*===========================================================================*/
/* Function: Read To File From Instrument                                    */
/* Purpose:  This function is used to read data from the instrument and      */
/*           write it to a user specified file.                              */
/*===========================================================================*/
ViStatus gwsfg830_readToFile (ViSession instrSession, ViString filename,
                    ViUInt32 readBytes, ViPUInt32 retCount)
{
    ViStatus  gwsfg830_status = VI_SUCCESS;
    ViByte    buffer[BUFFER_SIZE];
    ViUInt32  bytesReadInstr = 0, bytesWrittenFile = 0;
    FILE     *targetFile;

    *retCount = 0L;
    if ((targetFile = fopen (filename, "wb")) == VI_NULL)
        return VI_ERROR_INSTR_FILE_OPEN; /* not defined by VTL */

    for (;;) {
        if (readBytes > BUFFER_SIZE)
            gwsfg830_status = viRead (instrSession, buffer, BUFFER_SIZE, &bytesReadInstr);
        else
            gwsfg830_status = viRead (instrSession, buffer, readBytes, &bytesReadInstr);

        bytesWrittenFile = fwrite (buffer, sizeof (ViByte), (size_t)bytesReadInstr, targetFile);
        *retCount += bytesWrittenFile;
        if (bytesWrittenFile < bytesReadInstr)
            gwsfg830_status = VI_ERROR_INSTR_FILE_WRITE; /* not defined by VTL */

        if ((readBytes <= BUFFER_SIZE) || (gwsfg830_status <= 0) || (gwsfg830_status == VI_SUCCESS_TERM_CHAR))
            break;

        readBytes -= BUFFER_SIZE;
    }

    fclose (targetFile);
    return gwsfg830_status;
}

/*===========================================================================*/
/* Function: Write From File To Instrument                                   */
/* Purpose:  This function is used to read data from a user specified file   */
/*           and write it to the instrument.                                 */
/*===========================================================================*/
ViStatus gwsfg830_writeFromFile (ViSession instrSession, ViString filename,
                    ViUInt32 writeBytes, ViPUInt32 retCount)
{
    ViStatus  gwsfg830_status = VI_SUCCESS;
    ViByte    buffer[BUFFER_SIZE];
    ViUInt32  bytesRead = 0, bytesWritten = 0;
    FILE     *sourceFile;
    ViBoolean sendEnd = VI_FALSE;

    *retCount = 0L;
    if ((sourceFile = fopen (filename, "rb")) == VI_NULL)
        return VI_ERROR_INSTR_FILE_OPEN; /* not defined by VTL */

    while (!feof (sourceFile)) {
        bytesRead = (ViUInt32)fread (buffer, sizeof (ViByte), BUFFER_SIZE, sourceFile);
        if ((writeBytes > BUFFER_SIZE) && (bytesRead == BUFFER_SIZE)) {
            viGetAttribute (instrSession, VI_ATTR_SEND_END_EN, &sendEnd);
            viSetAttribute (instrSession, VI_ATTR_SEND_END_EN, VI_FALSE);
            gwsfg830_status = viWrite (instrSession, buffer, BUFFER_SIZE, &bytesWritten);
            viSetAttribute (instrSession, VI_ATTR_SEND_END_EN, sendEnd);
            writeBytes -= BUFFER_SIZE;
            *retCount += bytesWritten;
            if (gwsfg830_status < 0)
                break;
        }
        else {
            gwsfg830_status = viWrite (instrSession, buffer, ((bytesRead < writeBytes) ? bytesRead : writeBytes), &bytesWritten);
            *retCount += bytesWritten;
            break;
        }
    }

    fclose (sourceFile);
    return gwsfg830_status;
}

/*****************************************************************************/
/*----------- INSERT INSTRUMENT-DEPENDENT UTILITY ROUTINES HERE -------------*/
/*****************************************************************************/

/*===========================================================================*/
/* Function: Default Instrument Setup                                        */
/* Purpose:  This function sends a default setup to the instrument.  This    */
/*           function is called by the gwsfg830_reset operation and by the     */
/*           gwsfg830_init function if the reset option has not been           */
/*           selected.  This function is useful for configuring any          */
/*           instrument settings that are required by the rest of the        */
/*           instrument driver functions such as turning headers ON or OFF   */
/*           or using the long or short form for commands, queries, and data.*/                                    
/*===========================================================================*/
ViStatus gwsfg830_defaultInstrSetup (ViSession instrSession)
{
    ViStatus gwsfg830_status = VI_SUCCESS;
    ViUInt32 retCnt = 0;
    gwsfg830_instrRange instrPtr;
    
    /* Determine if the structure has been initialized for the current VISA  */
    /* Session and malloc if it has not.                                     */
    if (gwsfg830_status = viGetAttribute (instrSession, VI_ATTR_USER_DATA, &instrPtr))
        return gwsfg830_status;
    
    if (instrPtr == NULL) 
        instrPtr = malloc (sizeof (struct gwsfg830_statusDataRanges));

    /*=CHANGE:=============================================================*/
    /* Change to reflect the global status variables that your driver needs*/
    /* to keep track of.  For example trigger mode of each session         */
    /*=====================================================================*/
    instrPtr -> triggerMode = 0;
    instrPtr -> val2 = 0;
    instrPtr -> val3 = 0;
    Fmt (instrPtr -> instrDriverRevision, "%s<%s", gwsfg830_REVISION);
    
    if ((gwsfg830_status = viSetAttribute (instrSession, VI_ATTR_USER_DATA, 
                            (ViUInt32)instrPtr)) < 0)
        return gwsfg830_status;                                       


    return gwsfg830_status;
}

/*****************************************************************************/
/*=== END INSTRUMENT DRIVER SOURCE CODE =====================================*/
/*****************************************************************************/
